/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.managed.GroupProperties;
import com.ibm.hwmca.fw.managed.HwmcaParentObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Collection;
import java.util.Iterator;

public abstract class Group
extends HwmcaParentObject
implements GroupProperties {
    protected boolean busy;
    Class[] permittedChildren = null;
    Object permittedChildrenMonitor = new Object();
    private static final String TRACE_MASKT = "XFRMGRPT";
    private static final String TRACE_MASKF = "XFRMGRPF";
    private static final String TRACE_MASKD = "XFRMGRPD";

    protected Group(String name) {
        ObjectId id = new ObjectId(this);
        if (name != null) {
            id.setKeyProperty("Name", name);
        }
        this.setObjectId(id);
    }

    protected Group(PersistentData data, String persistKey) {
        super(data, persistKey);
    }

    public String getName() {
        String result = (String)this.getObjectId().getKeyProperty("Name");
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusy(boolean busy) {
        Trace.trace(TRACE_MASKT, "-> setBusy(busy=" + busy + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldBusy = this.busy;
            this.busy = busy;
            this.firePropertyChange("Busy", oldBusy, busy);
        }
        Trace.trace(TRACE_MASKT, "<- setBusy()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getPermittedChildren() {
        Trace.trace(TRACE_MASKT, "<> getPermittedChildren()");
        Object object = this.permittedChildrenMonitor;
        synchronized (object) {
            return this.permittedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermittedChildren(Class[] permittedChildren) {
        Trace.trace(TRACE_MASKT, "<> setPermittedChildren()");
        Object object = this.permittedChildrenMonitor;
        synchronized (object) {
            this.permittedChildren = permittedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChildPermitted(ObjectId child) {
        boolean result = false;
        Object object = this.permittedChildrenMonitor;
        synchronized (object) {
            if (this.permittedChildren != null) {
                int ix = 0;
                while (ix < this.permittedChildren.length && !result) {
                    if (child.isInstanceOf(this.permittedChildren[ix])) {
                        result = true;
                    }
                    ++ix;
                }
            } else {
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<> isChildPermitted(return " + result + ")");
        return result;
    }

    public void addChild(ObjectId childId) {
        if (!this.isChildPermitted(childId)) {
            throw new IllegalArgumentException("Child objectid (" + childId + ") is not permitted in this group.");
        }
        super.addChild(childId);
    }

    public void addChildren(Collection children) {
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            ObjectId childId = (ObjectId)iterator.next();
            if (this.isChildPermitted(childId)) continue;
            throw new IllegalArgumentException("Child objectid (" + childId + ") is not permitted in this group.");
        }
        super.addChildren(children);
    }
}

